% Read EXCEL input: share; eps_target; eps_calib; eta_target; eta_calib
data = xlsread('.\input\elastheta.xlsx','4x4','B3:F6');

%{
data in the worksheet "4x4"

sector	share   eps_target	eps_calib	eta_target	eta_calib				
s01     0.1178	-0.4294     -0.4657     0.7300      0.8442
s02     0.2479	-0.6650     -0.7201     0.9997      1.0000
s03     0.3955	-0.7800     -0.5767     1.0543      1.0289
s04     0.2388	-0.7424     -0.7445     1.0435      1.0289
%}

% Declare dimension
n = 4;

% Check Engel's aggregation (variable engel = 1 must hold)
eta_target = data(1:n, 4:4);
theta = data(1:n, 1:1);
engel = theta'*eta_target;

% Create a diagonal matrix with diagonal terms being the own-price AUES elasticities
eps_target = data(1:n, 2:2);
theta_diag = diag(theta);
aues_diag = diag(inv(theta_diag)*eps_target);

% Initialize the determinants for checking ND (sa stores values of various determinants)
sa = zeros(n,1);
for i = 1:n-1
    sa(i) = (-1)^(i+1);
end

while sa(1)>0|sa(2)<0|sa(3)>0|abs(sa(4))>0.00000001

% Empty aues from the previous run    
aues_off = zeros(n,n);        

% For each row create random variables no larger than the |diagonal term|/n
for i = 1:n-3
    offi = (-1+2*rand)*abs(aues_diag(i,i))/n;
    for j = i+1:n-1
         aues_off(i,j) = offi;
         aues_off(j,i) = aues_off(i,j);
    end
end

aues = aues_diag + aues_off;

% Create the "A" (LHS coefficient) matrix for solving the unknowns
A = zeros(n,n);
for i = 1:n-1
    A(i,i) = theta(n,1);
    A(n,i) = theta(i,1);
end
A(n-2,n) = theta(n-1,1);
A(n-1,n) = theta(n-2,1);

% This incomplete aues matrix is suitable for finding "C" (RHS coefficient) matrix 
C = -aues*theta;

% The unknowns are in "B" and are solved by A*B = C
B = inv(A)*C;

% Assign "B" to uknowns in aues, and now all aues unknows are found
for i = 1:n-1
    aues(i,n) = B(i,1);
end
aues(n-2,n-1) = B(n,1);

% Assign the solved AUES unknows (i,j) to their corresponding (j,i) elements 
for i = 1:n
    for j= 1:n
aues(j,i) = aues(i,j);
    end
end

% Check Cournot aggregation
cournot = aues*theta;

% Check NSD
for i = 1:n
sa(i) = det(aues(1:i, 1:i)/10);
end

end